
  /*
   *  Object %name    : main.c%
   *  State           :  %state%
   *  Creation date   :  Wed Nov 17 17:39:24 2004
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief This file includes the post boot functionality till the  
   *
   *  \version parser.c#1:csrc:1
   *  \author avis
   *  \remarks Copyright (C) 2004 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/************* Include Files ****************/

#include "DX_VOS_BaseTypes.h"
#include "ExtApp_op_code.h"
#include "ExtApp_sep_parser.h"
#include "connectivitytest_msg_defs.h"
#include "extInt_msg_defs.h"
#include "timer_msg_defs.h"
#include "extapp_err.h"
#include "sep_utils.h"

/************************ Defines ****************************/
/************************ Enums ******************************/
/************************ Typedefs ***************************/
/************************ Global Data ************************/



/*************************************************************************************   
*  @brief Decode the op-code for 3rd party applications and call corresponding 3party parser.
*
*  @param msg_ptr		[in]	Pointer to the received message buffer in the shared memory
*  @param msgSize_ptr	[out]	Pointer to the Size of the sent message in the shared memory
*  @return DX_SUCCESS	The operation completed successfully.
*  @return DX_FAILURE	The operation failed.
**/
DxUint32_t APP3PARTY_SEPMainParser( DxUint32_t* msg_ptr, DxUint32_t* msgLen_ptr )
{
	/*opcode of the message*/
	DxUint32_t	opCode;
    
	opCode = DX_SEP_GetMsgOpCode(msg_ptr);

	switch(opCode)
	{
		case DX_SEP_HOST_SEP_PROTOCOL_HOST_CONNECTIVITY_TEST_OP_CODE:
			*msgLen_ptr = DX_SEP_PARSER_ConnectivityTest(msg_ptr);
			break;
		case DX_SEP_HOST_SEP_PROTOCOL_EXT_INT_OP_CODE:
			*msgLen_ptr = DX_SEP_PARSER_ExIntHandler(msg_ptr);
			break;
        case DX_SEP_HOST_SEP_PROTOCOL_TIMER_INT_OP_CODE:
			*msgLen_ptr = DX_SEP_PARSER_timerHandler(msg_ptr);
            break;
		case DX_SEP_HOST_SEP_PROTOCOL_HOST_REQ1_OP_CODE:
			/* call spesific parser and set msgLen */
		case DX_SEP_HOST_SEP_PROTOCOL_HOST_REQ2_OP_CODE:
			/* call spesific parser and set msgLen */
		case DX_SEP_HOST_SEP_PROTOCOL_HOST_REQ3_OP_CODE:
			/* call spesific parser and set msgLen */
		case DX_SEP_HOST_SEP_PROTOCOL_HOST_REQ4_OP_CODE:
			/* call spesific parser and set msgLen */
		case DX_SEP_HOST_SEP_PROTOCOL_HOST_REQ5_OP_CODE:
			/* call spesific parser and set msgLen */
		default:
			return DX_FAILURE;
	}

	return DX_SUCCESS;
}




